<?php

class pluginAutoUpdater extends Plugin {

    public function init() {
        $this->formButtons = false;
    }

    public function post() {
        if (isset($_POST['run_update'])) {
            @set_time_limit(300);
            $logPath = $this->phpPath() . 'updater_log.txt';
            $rootPath = PATH_ROOT;
            
            // 1. Détection GitHub
            $apiUrl = "https://api.github.com/repos/bludit/bludit/releases/latest";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Bludit-Updater');
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $apiResponse = curl_exec($ch);
            curl_close($ch);

            $data = json_decode($apiResponse, true);
            $latestVersion = isset($data['tag_name']) ? str_replace('v', '', $data['tag_name']) : '';

            // Comparaison de version
            if ($latestVersion === BLUDIT_VERSION) {
                file_put_contents($logPath, "--- INFO : " . date('H:i:s') . " ---\n✅ Votre système est déjà à jour (v" . BLUDIT_VERSION . "). Aucune action requise.\n");
                return true;
            }

            file_put_contents($logPath, "--- DÉBUT MISE À JOUR : " . date('H:i:s') . " ---\n");
            file_put_contents($logPath, "🔄 Passage de " . BLUDIT_VERSION . " vers " . $latestVersion . "\n", FILE_APPEND);

            $downloadUrl = "https://github.com/bludit/bludit/archive/refs/tags/v" . $latestVersion . ".zip";
            $zipContent = $this->downloadFile($downloadUrl);
            
            if (!$zipContent) {
                $zipContent = $this->downloadFile("https://github.com/bludit/bludit/archive/refs/tags/" . $latestVersion . ".zip");
            }

            if ($zipContent) {
                file_put_contents($rootPath . 'bludit-update.zip', $zipContent);
                if (class_exists('ZipArchive')) {
                    $zip = new ZipArchive;
                    if ($zip->open($rootPath . 'bludit-update.zip') === TRUE) {
                        $tempDir = $rootPath . 'updater_temp' . DS;
                        if(!is_dir($tempDir)) mkdir($tempDir, 0755, true);
                        $zip->extractTo($tempDir);
                        $zip->close();
                        unlink($rootPath . 'bludit-update.zip');

                        $check = glob($tempDir . 'bludit-*', GLOB_ONLYDIR);
                        if (!empty($check)) {
                            $src = $check[0];
                            foreach(['bl-kernel', 'bl-languages'] as $f) {
                                if(is_dir($src . DS . $f)) {
                                    Filesystem::copyRecursive($src . DS . $f, $rootPath . $f);
                                }
                            }
                            Filesystem::deleteRecursive($tempDir);
                            file_put_contents($logPath, "🎉 MISE À JOUR RÉUSSIE VERS " . $latestVersion, FILE_APPEND);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private function downloadFile($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $content = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return ($httpCode == 200) ? $content : false;
    }

    public function form() {
        global $security;
        $logPath = $this->phpPath() . 'updater_log.txt';
        $html = '';

        // Affichage du log
        if (file_exists($logPath)) {
            $html .= '<div style="background:#1a1a1a; color:#00ff00; padding:15px; margin-bottom:20px; border-radius:4px; font-family:monospace;">';
            $html .= '<pre style="color:#00ff00; background:transparent; border:none; padding:0; white-space:pre-wrap;">' . file_get_contents($logPath) . '</pre>';
            $html .= '</div>';
        }

        $html .= '<div class="card p-3 text-center">';
        $html .= '<div class="mb-3">';
        $html .= '<h5>Version actuelle de votre Bludit</h5>';
        $html .= '<span class="badge bg-secondary" style="font-size:1.5rem;">' . BLUDIT_VERSION . '</span>';
        $html .= '</div>';
        
        $html .= '<input type="hidden" name="tokenCSRF" value="'.$security->getTokenCSRF().'">';
        $html .= '<button name="run_update" value="true" class="btn btn-primary btn-lg" type="submit">Vérifier et installer les mises à jour</button>';
        
        $html .= '<div class="mt-2 text-muted small">';
        $html .= 'Le script comparera votre version avec la dernière release stable de GitHub.';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }
}