<?php

class AdminPageSearch extends Plugin {

    public function init()
    {
        $this->dbFields = array(
            'itemsPerPage' => 20
        );
    }

    public function form()
    {
        $html = '<div>';
        $html .= '<label>Résultats par page</label>';
        $html .= '<input type="number" name="itemsPerPage" value="'.$this->getValue('itemsPerPage').'" min="10" max="100">';
        $html .= '<span class="tip">Nombre de résultats à afficher par page (10-100)</span>';
        $html .= '</div>';
        return $html;
    }

    // Ajouter un lien dans la sidebar admin
    public function adminSidebar()
    {
        $pluginName = Text::lowercase(__CLASS__);
        $url = HTML_PATH_ADMIN_ROOT.'plugin/'.$pluginName;
        
        $html = '<a class="nav-link" href="'.$url.'">';
        $html .= '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">';
        $html .= '<path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>';
        $html .= '</svg>';
        $html .= ' Rechercher des pages';
        $html .= '</a>';
        return $html;
    }

    // Contrôleur pour gérer la recherche
    public function adminController()
    {
        global $layout;
        $layout['title'] = 'Recherche de pages | Bludit';
    }

    // Vue pour afficher l'interface de recherche
    public function adminView()
    {
        global $pages;
        global $security;
        
        $searchTerm = isset($_GET['q']) ? trim($_GET['q']) : '';
        $currentPage = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
        $itemsPerPage = $this->getValue('itemsPerPage');
        
        $results = array();
        $totalResults = 0;

        // Si un terme de recherche est fourni
        if (!empty($searchTerm)) {
            // Récupérer toutes les pages (publiées et brouillons)
            $publishedPages = $pages->getList(1, -1, true); // Pages publiées
            $draftPages = $pages->getList(1, -1, false); // Brouillons
            $staticPages = $pages->getStaticDB(true); // Pages statiques
            
            // Fusionner toutes les clés de pages
            $allPageKeys = array_unique(array_merge($publishedPages, $draftPages, $staticPages));
            
            foreach ($allPageKeys as $pageKey) {
                try {
                    $page = buildPage($pageKey);
                    $title = $page->title();
                    $slug = $page->slug();
                    $content = strip_tags($page->content());
                    
                    // Rechercher dans le titre, le slug et le contenu
                    $searchLower = mb_strtolower($searchTerm, 'UTF-8');
                    $titleLower = mb_strtolower($title, 'UTF-8');
                    $slugLower = mb_strtolower($slug, 'UTF-8');
                    $contentLower = mb_strtolower($content, 'UTF-8');
                    
                    if (mb_strpos($titleLower, $searchLower, 0, 'UTF-8') !== false || 
                        mb_strpos($slugLower, $searchLower, 0, 'UTF-8') !== false ||
                        mb_strpos($contentLower, $searchLower, 0, 'UTF-8') !== false) {
                        
                        $results[] = array(
                            'key' => $pageKey,
                            'title' => $title,
                            'slug' => $slug,
                            'date' => $page->dateRaw(),
                            'username' => $page->username(),
                            'category' => $page->category(),
                            'draft' => $page->draft() ? 'scheduled' : 'published',
                            'static' => $page->isStatic(),
                            'permalink' => $page->permalink()
                        );
                    }
                } catch (Exception $e) {
                    // Ignorer les pages qui ne peuvent pas être chargées
                }
            }
            
            $totalResults = count($results);
            
            // Pagination
            $offset = ($currentPage - 1) * $itemsPerPage;
            $results = array_slice($results, $offset, $itemsPerPage);
        }
        
        $totalPages = !empty($searchTerm) ? ceil($totalResults / $itemsPerPage) : 0;
        
        $pluginName = Text::lowercase(__CLASS__);
        $baseUrl = HTML_PATH_ADMIN_ROOT.'plugin/'.$pluginName;
        
        // Générer le HTML
        $html = '
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="mt-4 mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16" style="vertical-align: -5px;">
                            <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                        </svg>
                        Rechercher des pages
                    </h1>
                    
                    <div class="card mb-4">
                        <div class="card-body">
                            <form method="get" action="'.$baseUrl.'" class="form-inline">
                                <div class="input-group w-100">
                                    <input type="text" 
                                           name="q" 
                                           class="form-control form-control-lg" 
                                           placeholder="Rechercher par titre, slug ou contenu..." 
                                           value="'.htmlspecialchars($searchTerm, ENT_QUOTES, 'UTF-8').'"
                                           autofocus>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary btn-lg" type="submit">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                                <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                            </svg>
                                            Rechercher
                                        </button>';
        
        if (!empty($searchTerm)) {
            $html .= '
                                        <a href="'.$baseUrl.'" class="btn btn-secondary btn-lg">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                                <path d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z"/>
                                            </svg>
                                            Effacer
                                        </a>';
        }
        
        $html .= '
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>';
        
        // Afficher les résultats
        if (!empty($searchTerm)) {
            $html .= '<div class="alert alert-info">';
            $html .= '<strong>'.$totalResults.'</strong> page(s) trouvée(s) pour "<strong>'.htmlspecialchars($searchTerm, ENT_QUOTES, 'UTF-8').'</strong>"';
            $html .= '</div>';
            
            if ($totalResults > 0) {
                $html .= '<div class="table-responsive">';
                $html .= '<table class="table table-striped table-hover">';
                $html .= '<thead class="thead-light">';
                $html .= '<tr>';
                $html .= '<th>Titre</th>';
                $html .= '<th>Slug</th>';
                $html .= '<th>Date</th>';
                $html .= '<th>Auteur</th>';
                $html .= '<th>État</th>';
                $html .= '<th>Actions</th>';
                $html .= '</tr>';
                $html .= '</thead>';
                $html .= '<tbody>';
                
                foreach ($results as $result) {
                    $html .= '<tr>';
                    $html .= '<td><strong>'.htmlspecialchars($result['title'], ENT_QUOTES, 'UTF-8').'</strong></td>';
                    $html .= '<td><code>'.$result['slug'].'</code></td>';
                    
                    // Format de date sécurisé
                    $dateFormatted = 'N/A';
                    if (!empty($result['date'])) {
                        try {
                            $timestamp = strtotime($result['date']);
                            if ($timestamp !== false) {
                                $dateFormatted = date('d/m/Y', $timestamp);
                            }
                        } catch (Exception $e) {
                            $dateFormatted = 'N/A';
                        }
                    }
                    
                    $html .= '<td>'.$dateFormatted.'</td>';
                    $html .= '<td>'.htmlspecialchars($result['username'], ENT_QUOTES, 'UTF-8').'</td>';
                    $html .= '<td>';
                    
                    if ($result['draft'] === 'scheduled') {
                        $html .= '<span class="badge badge-warning">Brouillon</span>';
                    } elseif ($result['static']) {
                        $html .= '<span class="badge badge-info">Statique</span>';
                    } else {
                        $html .= '<span class="badge badge-success">Publié</span>';
                    }
                    
                    $html .= '</td>';
                    $html .= '<td>';
                    $html .= '<a href="'.HTML_PATH_ADMIN_ROOT.'edit-content/'.$result['key'].'" class="btn btn-sm btn-primary">Éditer</a> ';
                    $html .= '<a href="'.$result['permalink'].'" class="btn btn-sm btn-secondary" target="_blank">Voir</a>';
                    $html .= '</td>';
                    $html .= '</tr>';
                }
                
                $html .= '</tbody>';
                $html .= '</table>';
                $html .= '</div>';
                
                // Pagination
                if ($totalPages > 1) {
                    $html .= '<nav aria-label="Pagination des résultats">';
                    $html .= '<ul class="pagination justify-content-center">';
                    
                    // Bouton précédent
                    if ($currentPage > 1) {
                        $html .= '<li class="page-item">';
                        $html .= '<a class="page-link" href="'.$baseUrl.'?q='.urlencode($searchTerm).'&page='.($currentPage-1).'">Précédent</a>';
                        $html .= '</li>';
                    }
                    
                    // Numéros de page
                    for ($i = max(1, $currentPage - 2); $i <= min($totalPages, $currentPage + 2); $i++) {
                        $activeClass = ($i == $currentPage) ? ' active' : '';
                        $html .= '<li class="page-item'.$activeClass.'">';
                        $html .= '<a class="page-link" href="'.$baseUrl.'?q='.urlencode($searchTerm).'&page='.$i.'">'.$i.'</a>';
                        $html .= '</li>';
                    }
                    
                    // Bouton suivant
                    if ($currentPage < $totalPages) {
                        $html .= '<li class="page-item">';
                        $html .= '<a class="page-link" href="'.$baseUrl.'?q='.urlencode($searchTerm).'&page='.($currentPage+1).'">Suivant</a>';
                        $html .= '</li>';
                    }
                    
                    $html .= '</ul>';
                    $html .= '</nav>';
                }
            }
        } else {
            $html .= '<div class="alert alert-light text-center py-5">';
            $html .= '<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-search mb-3" viewBox="0 0 16 16" style="opacity: 0.3;">';
            $html .= '<path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>';
            $html .= '</svg>';
            $html .= '<h4>Recherchez dans toutes vos pages</h4>';
            $html .= '<p class="text-muted">Entrez un mot-clé pour rechercher dans les titres, slugs et contenu de toutes vos pages.</p>';
            $html .= '</div>';
        }
        
        $html .= '
                </div>
            </div>
        </div>';
        
        return $html;
    }
}