<?php
/**
 * Essential Audio Player
 * Lecteur audio minimaliste HTML5/JavaScript/CSS
 * 
 * @package Bludit
 * @subpackage Plugins
 * @author Votre nom
 * @link https://essential-audio-player.net/
 */

class pluginEssentialAudioPlayer extends Plugin {

    public function init() {
        $this->dbFields = array(
            'enableLoop' => false,
            'enablePreload' => false,
            'enableScratch' => false,
            'enablePassive' => true
        );
    }

    public function form() {
        global $L;

        $html = '<div class="alert alert-primary" role="alert">';
        $html .= '<h4 class="alert-heading">Comment utiliser</h4>';
        $html .= '<p>Dans vos pages ou articles, ajoutez simplement :</p>';
        $html .= '<code>&lt;div class="essential_audio" data-url="chemin/vers/audio.mp3"&gt;&lt;/div&gt;</code>';
        $html .= '<hr>';
        $html .= '<p class="mb-0"><strong>Options :</strong> data-loop, data-preload, data-scratch, data-passive</p>';
        $html .= '</div>';

        $html .= '<div>';
        
        $html .= '<label>Mode boucle par défaut</label>';
        $html .= '<select name="enableLoop">';
        $html .= '<option value="true" '.($this->getValue('enableLoop') === true ? 'selected' : '').'>Activé</option>';
        $html .= '<option value="false" '.($this->getValue('enableLoop') === false ? 'selected' : '').'>Désactivé</option>';
        $html .= '</select>';
        $html .= '<span class="tip">Les lecteurs joueront en boucle</span>';
        
        $html .= '</div>';

        $html .= '<div>';
        
        $html .= '<label>Préchargement</label>';
        $html .= '<select name="enablePreload">';
        $html .= '<option value="true" '.($this->getValue('enablePreload') === true ? 'selected' : '').'>Activé</option>';
        $html .= '<option value="false" '.($this->getValue('enablePreload') === false ? 'selected' : '').'>Désactivé</option>';
        $html .= '</select>';
        $html .= '<span class="tip">Précharge les fichiers audio (consomme de la bande passante)</span>';
        
        $html .= '</div>';

        $html .= '<div>';
        
        $html .= '<label>Mode scratch</label>';
        $html .= '<select name="enableScratch">';
        $html .= '<option value="true" '.($this->getValue('enableScratch') === true ? 'selected' : '').'>Activé</option>';
        $html .= '<option value="false" '.($this->getValue('enableScratch') === false ? 'selected' : '').'>Désactivé</option>';
        $html .= '</select>';
        $html .= '<span class="tip">Permet de scratcher en déplaçant le curseur</span>';
        
        $html .= '</div>';

        $html .= '<div>';
        
        $html .= '<label>Écouteurs passifs (mobile)</label>';
        $html .= '<select name="enablePassive">';
        $html .= '<option value="true" '.($this->getValue('enablePassive') === true ? 'selected' : '').'>Activé</option>';
        $html .= '<option value="false" '.($this->getValue('enablePassive') === false ? 'selected' : '').'>Désactivé</option>';
        $html .= '</select>';
        $html .= '<span class="tip">Recommandé pour les appareils mobiles</span>';
        
        $html .= '</div>';

        return $html;
    }

    public function siteHead() {
        $html = '<link rel="stylesheet" href="'.$this->htmlPath().'assets/essential_audio.css">';
        return $html;
    }

    public function siteBodyEnd() {
        $html = '<script src="'.$this->htmlPath().'assets/essential_audio.js"></script>';
        return $html;
    }
}